﻿using VA.TMP.Integration.VIMT.VirtualMeetingRoom.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.VirtualMeetingRoom.PipelineSteps.OnDemand
{
    /// <summary>
    /// Create Patient/Provider URL step.
    /// </summary>
    public class CreateUrlsStep : FilterBase<VmrOnDemandCreateStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(VmrOnDemandCreateStateObject state)
        {
            if (state.ExceptionOccured) return;

            state.ProviderUrl = string.Format(state.ProviderVmrFormatUrl, state.VmrBaseUrl, state.VmrBaseUrlExtension, state.ProviderId, state.MeetingRoomName, state.VirtualMeetingRoomSuffix, state.ProviderPin);
            state.PatientUrl = string.Format(state.PatientVmrFormatUrl, state.VmrBaseUrl, state.VmrBaseUrlExtension, state.MeetingRoomName, state.VirtualMeetingRoomSuffix, state.PatientPin);

            if (state.UseFakeResponse) state.MiscDataForResponse = string.Format("hostDialUrl={0};guestDialUrl={1};", state.ProviderUrl, state.PatientUrl);                         
        }
    }
}